#include <iostream>
#include <iomanip>
#include <algorithm>
#include <cmath>
#include <numeric>
#include <random>
#include <ctime>
#include <chrono>
#include <cassert>
#include <vector>
#include <string>
#include <set>
#include <unordered_set>
#include <map>
#include <unordered_map>
#include <deque>
#include <bitset>
using namespace std;
mt19937_64 rnd(time(NULL));

const long long INF = 1e18, MOD = 998244353;

/*
struct segtree
{
    long long n = 0;
    vector<long long> t = {};

    segtree() = default;

    segtree(vector<long long>& in)
    {
        n = in.size();
        t.resize(n * 4);
        build(0, 0, n - 1, in);
    }

    void build(long long v, long long tl, long long tr, vector<long long>& in)
    {
        if (tl == tr)
        {
            t[v] = in[tl];
            return;
        }

        long long tm = (tl + tr) / 2;
        build(v * 2 + 1, tl, tm, in);
        build(v * 2 + 2, tm + 1, tr, in);
        t[v] = t[v * 2 + 1] + t[v * 2 + 2];
    }

    long long get_seg(long long v, long long tl, long long tr, long long l, long long r)
    {
        if (tr < l || r < tl)
        {
            return 0;
        }
        if (l <= tl && tr <= r)
        {
            return t[v];
        }

        long long tm = (tl + tr) / 2;
        return get_seg(v * 2 + 1, tl, tm, l, r) + get_seg(v * 2 + 2, tm + 1, tr, l, r);
    }

    long long get(long long l, long long r)
    {
        return get_seg(0, 0, n - 1, l, r);
    }

    void upd_elem(long long v, long long tl, long long tr, long long pos, long long val)
    {
        if (tl == tr)
        {
            t[v] = val;
            return;
        }

        long long tm = (tl + tr) / 2;
        if (pos <= tm)
        {
            upd_elem(v * 2 + 1, tl, tm, pos, val);
        }
        else
        {
            upd_elem(v * 2 + 2, tm + 1, tr, pos, val);
        }
        t[v] = t[v * 2 + 1] + t[v * 2 + 2];
    }

    void upd(long long pos, long long val)
    {
        upd_elem(0, 0, n - 1, pos, val);
    }
};
 */

long long binpow(long long a, long long n)
{
    if (!n)
    {
        return 1;
    }

    long long res = binpow(a, n / 2);
    res = (res * res) % MOD;
    if (n % 2)
    {
        res *= a;
        res %= MOD;
    }
    return res;
}

long long inv(long long a)
{
    return binpow(a, MOD - 2);
}

long long dp[5002][5002], horiz[5002][5002], vert[5002][5002];

long long mod(long long a)
{
    a %= MOD;
    if (a < 0)
    {
        a += MOD;
    }
    return a;
}

void solve()
{
    long long n, m;
    cin>>n>>m;
    if (m == 1)
    {
        cout << n << "\n";
        return;
    }

    for (int i = 0; i < n + 1; ++i) {
        for (int j = 0; j < n + 1; ++j) {
            dp[i][j] = horiz[i][j] = vert[i][j] = 0;
        }
    }

    long long ans = 0;
    for (int i = 1; i < n + 1; ++i) {
        for (int j = 1; j < i; ++j) {
            dp[i][j] = horiz[i - j][j] + mod(vert[i - 1][j] - vert[i - j][j]);
            dp[i][j] *= (m - 1);
            dp[i][j] %= MOD;
            if (i == n)
            {
                ans += (dp[i][j] * j) % MOD;
                ans %= MOD;
            }
        }
        dp[i][i] = m;
        if (i == n)
        {
            ans += (m * i) % MOD;
            ans % MOD;
        }
        for (int j = 1; j < n + 1; ++j) {
            horiz[i][j] = (horiz[i][j - 1] + dp[i][j]) % MOD;
            vert[i][j] = (vert[i - 1][j] + dp[i][j]) % MOD;
        }
    }
    cout << (ans * inv(binpow(m, n))) % MOD << "\n";
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    int tst = 1;
    cin>>tst;
    while (tst--)
    {
        solve();
    }

    return 0;
}

/*


















 */
